#define sensorPin   A3     
#define alimPin 3

float R0 = 10000 ; // résistance du pont diviseur
float R25 = 10000; // résistance de référence de la thermistance
float B = 3950 ; // coefficient de température de la thermistance

void setup()
{
  Serial.begin(115200) ;
  sensors.begin();
  pinMode(alimPin, OUTPUT);
  digitalWrite(alimPin, HIGH) ;
}

void loop()
{
  Serial.println(getT()) ;
  delay(1000) ;
}

float getT()
{
  int sensorValue = analogRead(sensorPin);
  float RT=R0/((1023.0/sensorValue)-1) ;
  float T = 1/(log(RT/R25)/B+1/298.15);
  return T-273.15 ; 
}
