// capteur DS18B20
#include <OneWire.h>
#include <DallasTemperature.h>
#define ONE_WIRE_BUS 2
OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensors(&oneWire);
int nbTemperature ; 

// capteur infrarouge
#include <Adafruit_MLX90614.h>
Adafruit_MLX90614 mlx = Adafruit_MLX90614();

// thermistance
#define sensorPin   A3     
#define alimPin 3
float R0 = 10000 ; // résistance du pont diviseur
float R25 = 10000; // résistance de référence de la thermistance
float B = 3950 ; // coefficient de température de la thermistance

// affichage sur écran LCD
#include <Adafruit_SSD1306.h>
Adafruit_SSD1306 lcd(4);

void setup()
{
  Serial.begin(115200) ;
  sensors.begin();
  nbTemperature = sensors.getDeviceCount() ;
  Serial.println(nbTemperature) ; 
  pinMode(alimPin, OUTPUT);
  digitalWrite(alimPin, HIGH) ;
 
  mlx.begin();  
  Serial.println("Programme : MiniShield_Temperature") ; 
  
  lcd.begin(SSD1306_SWITCHCAPVCC, 0x3C);  
  lcd.setTextSize(1);
  lcd.setTextColor(WHITE);
  lcd.clearDisplay() ;
  lcd.setCursor(0,0);
  lcd.print("MiniShield T") ; 
  lcd.display()  ;
}

void loop()
{
  String msg = "DATA:TIMES:" + String(millis()/1000.0,1) ;  
  lcd.clearDisplay();
  if (nbTemperature > 0)
  {
  sensors.requestTemperatures(); // Send the command to get temperatures
  for (int i = 0 ; i < nbTemperature ; i++)
  {
    msg = msg + ":T" + String(i+1) + ":" + String(sensors.getTempCByIndex(i),1);
    lcd.setCursor(30*i,0) ; 
    lcd.print(String(sensors.getTempCByIndex(i),1)) ; 
  }
  }
  float T2 = getT() ; 
  msg = msg + ":CTN:"+String(T2,1) ; 
  float TIR = mlx.readObjectTempC();
  msg = msg + ":IR:"+String(TIR,1) ;
  Serial.println(msg) ; 

  lcd.setCursor(0,12);
  lcd.print("T2 = ") ;
  lcd.println(String(T2,1)) ; 
  lcd.setCursor(0,24);
  lcd.print("T(IR) = ") ;
  lcd.println(String(TIR,1)) ; 
  lcd.display() ; 
  
  delay(1000) ;

}

float getT()
{
  int sensorValue = analogRead(sensorPin);
  float RT=R0/((1023.0/sensorValue)-1) ;
  float T = 1/(log(RT/R25)/B+1/298.15);
  return T-273.15 ; 
}
